package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data. */
final case class Event(
  involvedObject : io.k8s.api.core.v1.ObjectReference,
  series : Option[io.k8s.api.core.v1.EventSeries] = None,
  count : Option[Int] = None,
  source : Option[io.k8s.api.core.v1.EventSource] = None,
  reportingComponent : Option[String] = None,
  reason : Option[String] = None,
  related : Option[io.k8s.api.core.v1.ObjectReference] = None,
  eventTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  lastTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  metadata : io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta,
  message : Option[String] = None,
  firstTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  `type` : Option[String] = None,
  reportingInstance : Option[String] = None,
  action : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Event", "v1")

  def withInvolvedObject(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(involvedObject = value)
  def withSeries(value: io.k8s.api.core.v1.EventSeries) : Event = copy(series = Some(value))
  def withCount(value: Int) : Event = copy(count = Some(value))
  def withSource(value: io.k8s.api.core.v1.EventSource) : Event = copy(source = Some(value))
  def withReportingComponent(value: String) : Event = copy(reportingComponent = Some(value))
  def withReason(value: String) : Event = copy(reason = Some(value))
  def withRelated(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(related = Some(value))
  def withEventTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = Some(value))
  def withLastTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(lastTimestamp = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = value)
  def withMessage(value: String) : Event = copy(message = Some(value))
  def withFirstTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(firstTimestamp = Some(value))
  def withType(value: String) : Event = copy(`type` = Some(value))
  def withReportingInstance(value: String) : Event = copy(reportingInstance = Some(value))
  def withAction(value: String) : Event = copy(action = Some(value))
}

