package io.k8s.api.core.v1


/** Represents an ephemeral volume that is handled by a normal storage driver. */
final case class EphemeralVolumeSource(
  volumeClaimTemplate : Option[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = None
) {
  def withVolumeClaimTemplate(value: io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : EphemeralVolumeSource = copy(volumeClaimTemplate = Some(value))
}

