package io.k8s.api.core.v1


/** EnvVar represents an environment variable present in a Container. */
final case class EnvVar(
  name : String,
  value : Option[String] = None,
  valueFrom : Option[io.k8s.api.core.v1.EnvVarSource] = None
) {
  def withName(value: String) : EnvVar = copy(name = value)
  def withValue(value: String) : EnvVar = copy(value = Some(value))
  def withValueFrom(value: io.k8s.api.core.v1.EnvVarSource) : EnvVar = copy(valueFrom = Some(value))
}

