package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** EndpointsList is a list of endpoints. */
final case class EndpointsList(
  items : Seq[io.k8s.api.core.v1.Endpoints],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "EndpointsList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.Endpoints]) : EndpointsList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.Endpoints*) : EndpointsList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : EndpointsList = copy(metadata = Some(value))
}

