package io.k8s.api.core.v1


/** EndpointAddress is a tuple that describes single IP address. */
final case class EndpointAddress(
  hostname : Option[String] = None,
  ip : String,
  nodeName : Option[String] = None,
  targetRef : Option[io.k8s.api.core.v1.ObjectReference] = None
) {
  def withHostname(value: String) : EndpointAddress = copy(hostname = Some(value))
  def withIp(value: String) : EndpointAddress = copy(ip = value)
  def withNodeName(value: String) : EndpointAddress = copy(nodeName = Some(value))
  def withTargetRef(value: io.k8s.api.core.v1.ObjectReference) : EndpointAddress = copy(targetRef = Some(value))
}

