package io.k8s.api.core.v1


/** DownwardAPIVolumeFile represents information to create the file containing the pod field */
final case class DownwardAPIVolumeFile(
  fieldRef : Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  mode : Option[Int] = None,
  path : String,
  resourceFieldRef : Option[io.k8s.api.core.v1.ResourceFieldSelector] = None
) {
  def withFieldRef(value: io.k8s.api.core.v1.ObjectFieldSelector) : DownwardAPIVolumeFile = copy(fieldRef = Some(value))
  def withMode(value: Int) : DownwardAPIVolumeFile = copy(mode = Some(value))
  def withPath(value: String) : DownwardAPIVolumeFile = copy(path = value)
  def withResourceFieldRef(value: io.k8s.api.core.v1.ResourceFieldSelector) : DownwardAPIVolumeFile = copy(resourceFieldRef = Some(value))
}

