package io.k8s.api.core.v1


/** Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode. */
final case class DownwardAPIProjection(
  items : Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
) {
  def withItems(value: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIProjection = copy(items = Some(value))
  def addItems(newValues: io.k8s.api.core.v1.DownwardAPIVolumeFile*) : DownwardAPIProjection = copy(items = Some(items.fold(newValues)(_ ++ newValues)))

}

