package io.k8s.api.core.v1


/** ContainerStatus contains details for the current status of this container. */
final case class ContainerStatus(
  name : String,
  state : Option[io.k8s.api.core.v1.ContainerState] = None,
  image : String,
  restartCount : Int,
  ready : Boolean,
  lastState : Option[io.k8s.api.core.v1.ContainerState] = None,
  imageID : String,
  containerID : Option[String] = None,
  started : Option[Boolean] = None
) {
  def withName(value: String) : ContainerStatus = copy(name = value)
  def withState(value: io.k8s.api.core.v1.ContainerState) : ContainerStatus = copy(state = Some(value))
  def withImage(value: String) : ContainerStatus = copy(image = value)
  def withRestartCount(value: Int) : ContainerStatus = copy(restartCount = value)
  def withReady(value: Boolean) : ContainerStatus = copy(ready = value)
  def withLastState(value: io.k8s.api.core.v1.ContainerState) : ContainerStatus = copy(lastState = Some(value))
  def withImageID(value: String) : ContainerStatus = copy(imageID = value)
  def withContainerID(value: String) : ContainerStatus = copy(containerID = Some(value))
  def withStarted(value: Boolean) : ContainerStatus = copy(started = Some(value))
}

