package io.k8s.api.core.v1


/** ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting. */
final case class ContainerState(
  running : Option[io.k8s.api.core.v1.ContainerStateRunning] = None,
  terminated : Option[io.k8s.api.core.v1.ContainerStateTerminated] = None,
  waiting : Option[io.k8s.api.core.v1.ContainerStateWaiting] = None
) {
  def withRunning(value: io.k8s.api.core.v1.ContainerStateRunning) : ContainerState = copy(running = Some(value))
  def withTerminated(value: io.k8s.api.core.v1.ContainerStateTerminated) : ContainerState = copy(terminated = Some(value))
  def withWaiting(value: io.k8s.api.core.v1.ContainerStateWaiting) : ContainerState = copy(waiting = Some(value))
}

