package io.k8s.api.core.v1


/** A single application container that you want to run within a pod. */
final case class Container(
  readinessProbe : Option[io.k8s.api.core.v1.Probe] = None,
  name : String,
  livenessProbe : Option[io.k8s.api.core.v1.Probe] = None,
  lifecycle : Option[io.k8s.api.core.v1.Lifecycle] = None,
  image : Option[String] = None,
  stdinOnce : Option[Boolean] = None,
  ports : Option[Seq[io.k8s.api.core.v1.ContainerPort]] = None,
  startupProbe : Option[io.k8s.api.core.v1.Probe] = None,
  command : Option[Seq[String]] = None,
  terminationMessagePolicy : Option[String] = None,
  stdin : Option[Boolean] = None,
  terminationMessagePath : Option[String] = None,
  resources : Option[io.k8s.api.core.v1.ResourceRequirements] = None,
  envFrom : Option[Seq[io.k8s.api.core.v1.EnvFromSource]] = None,
  volumeDevices : Option[Seq[io.k8s.api.core.v1.VolumeDevice]] = None,
  args : Option[Seq[String]] = None,
  tty : Option[Boolean] = None,
  imagePullPolicy : Option[String] = None,
  workingDir : Option[String] = None,
  volumeMounts : Option[Seq[io.k8s.api.core.v1.VolumeMount]] = None,
  env : Option[Seq[io.k8s.api.core.v1.EnvVar]] = None,
  securityContext : Option[io.k8s.api.core.v1.SecurityContext] = None
) {
  def withReadinessProbe(value: io.k8s.api.core.v1.Probe) : Container = copy(readinessProbe = Some(value))
  def withName(value: String) : Container = copy(name = value)
  def withLivenessProbe(value: io.k8s.api.core.v1.Probe) : Container = copy(livenessProbe = Some(value))
  def withLifecycle(value: io.k8s.api.core.v1.Lifecycle) : Container = copy(lifecycle = Some(value))
  def withImage(value: String) : Container = copy(image = Some(value))
  def withStdinOnce(value: Boolean) : Container = copy(stdinOnce = Some(value))
  def withPorts(value: Seq[io.k8s.api.core.v1.ContainerPort]) : Container = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.core.v1.ContainerPort*) : Container = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

  def withStartupProbe(value: io.k8s.api.core.v1.Probe) : Container = copy(startupProbe = Some(value))
  def withCommand(value: Seq[String]) : Container = copy(command = Some(value))
  def addCommand(newValues: String*) : Container = copy(command = Some(command.fold(newValues)(_ ++ newValues)))

  def withTerminationMessagePolicy(value: String) : Container = copy(terminationMessagePolicy = Some(value))
  def withStdin(value: Boolean) : Container = copy(stdin = Some(value))
  def withTerminationMessagePath(value: String) : Container = copy(terminationMessagePath = Some(value))
  def withResources(value: io.k8s.api.core.v1.ResourceRequirements) : Container = copy(resources = Some(value))
  def withEnvFrom(value: Seq[io.k8s.api.core.v1.EnvFromSource]) : Container = copy(envFrom = Some(value))
  def addEnvFrom(newValues: io.k8s.api.core.v1.EnvFromSource*) : Container = copy(envFrom = Some(envFrom.fold(newValues)(_ ++ newValues)))

  def withVolumeDevices(value: Seq[io.k8s.api.core.v1.VolumeDevice]) : Container = copy(volumeDevices = Some(value))
  def addVolumeDevices(newValues: io.k8s.api.core.v1.VolumeDevice*) : Container = copy(volumeDevices = Some(volumeDevices.fold(newValues)(_ ++ newValues)))

  def withArgs(value: Seq[String]) : Container = copy(args = Some(value))
  def addArgs(newValues: String*) : Container = copy(args = Some(args.fold(newValues)(_ ++ newValues)))

  def withTty(value: Boolean) : Container = copy(tty = Some(value))
  def withImagePullPolicy(value: String) : Container = copy(imagePullPolicy = Some(value))
  def withWorkingDir(value: String) : Container = copy(workingDir = Some(value))
  def withVolumeMounts(value: Seq[io.k8s.api.core.v1.VolumeMount]) : Container = copy(volumeMounts = Some(value))
  def addVolumeMounts(newValues: io.k8s.api.core.v1.VolumeMount*) : Container = copy(volumeMounts = Some(volumeMounts.fold(newValues)(_ ++ newValues)))

  def withEnv(value: Seq[io.k8s.api.core.v1.EnvVar]) : Container = copy(env = Some(value))
  def addEnv(newValues: io.k8s.api.core.v1.EnvVar*) : Container = copy(env = Some(env.fold(newValues)(_ ++ newValues)))

  def withSecurityContext(value: io.k8s.api.core.v1.SecurityContext) : Container = copy(securityContext = Some(value))
}

