package io.k8s.api.core.v1


/** ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration */
final case class ConfigMapNodeConfigSource(
  name : String,
  resourceVersion : Option[String] = None,
  kubeletConfigKey : String,
  uid : Option[String] = None,
  namespace : String
) {
  def withName(value: String) : ConfigMapNodeConfigSource = copy(name = value)
  def withResourceVersion(value: String) : ConfigMapNodeConfigSource = copy(resourceVersion = Some(value))
  def withKubeletConfigKey(value: String) : ConfigMapNodeConfigSource = copy(kubeletConfigKey = value)
  def withUid(value: String) : ConfigMapNodeConfigSource = copy(uid = Some(value))
  def withNamespace(value: String) : ConfigMapNodeConfigSource = copy(namespace = value)
}

