package io.k8s.api.core.v1


/** ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables. */
final case class ConfigMapEnvSource(
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {
  def withName(value: String) : ConfigMapEnvSource = copy(name = Some(value))
  def withOptional(value: Boolean) : ConfigMapEnvSource = copy(optional = Some(value))
}

