package io.k8s.api.core.v1


/** Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling. */
final case class CephFSVolumeSource(
  path : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  secretFile : Option[String] = None,
  monitors : Seq[String],
  user : Option[String] = None
) {
  def withPath(value: String) : CephFSVolumeSource = copy(path = Some(value))
  def withReadOnly(value: Boolean) : CephFSVolumeSource = copy(readOnly = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CephFSVolumeSource = copy(secretRef = Some(value))
  def withSecretFile(value: String) : CephFSVolumeSource = copy(secretFile = Some(value))
  def withMonitors(value: Seq[String]) : CephFSVolumeSource = copy(monitors = value)
  def addMonitors(newValues: String*) : CephFSVolumeSource = copy(monitors = monitors ++ newValues)

  def withUser(value: String) : CephFSVolumeSource = copy(user = Some(value))
}

