package io.k8s.api.core.v1


/** Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling. */
final case class CephFSPersistentVolumeSource(
  path : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  secretFile : Option[String] = None,
  monitors : Seq[String],
  user : Option[String] = None
) {
  def withPath(value: String) : CephFSPersistentVolumeSource = copy(path = Some(value))
  def withReadOnly(value: Boolean) : CephFSPersistentVolumeSource = copy(readOnly = Some(value))
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : CephFSPersistentVolumeSource = copy(secretRef = Some(value))
  def withSecretFile(value: String) : CephFSPersistentVolumeSource = copy(secretFile = Some(value))
  def withMonitors(value: Seq[String]) : CephFSPersistentVolumeSource = copy(monitors = value)
  def addMonitors(newValues: String*) : CephFSPersistentVolumeSource = copy(monitors = monitors ++ newValues)

  def withUser(value: String) : CephFSPersistentVolumeSource = copy(user = Some(value))
}

