package io.k8s.api.core.v1


/** Represents storage that is managed by an external CSI volume driver (Beta feature) */
final case class CSIPersistentVolumeSource(
  nodeStageSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  volumeHandle : String,
  driver : String,
  controllerPublishSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  volumeAttributes : Option[Map[String, String]] = None,
  controllerExpandSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  nodeExpandSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None,
  nodePublishSecretRef : Option[io.k8s.api.core.v1.SecretReference] = None
) {
  def withNodeStageSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeStageSecretRef = Some(value))
  def withReadOnly(value: Boolean) : CSIPersistentVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : CSIPersistentVolumeSource = copy(fsType = Some(value))
  def withVolumeHandle(value: String) : CSIPersistentVolumeSource = copy(volumeHandle = value)
  def withDriver(value: String) : CSIPersistentVolumeSource = copy(driver = value)
  def withControllerPublishSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerPublishSecretRef = Some(value))
  def withVolumeAttributes(value: Map[String, String]) : CSIPersistentVolumeSource = copy(volumeAttributes = Some(value))
  def addVolumeAttributes(newValues: (String, String)*) : CSIPersistentVolumeSource = copy(volumeAttributes = Some(volumeAttributes.fold(newValues.toMap)(_ ++ newValues)))

  def withControllerExpandSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(controllerExpandSecretRef = Some(value))
  def withNodeExpandSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodeExpandSecretRef = Some(value))
  def withNodePublishSecretRef(value: io.k8s.api.core.v1.SecretReference) : CSIPersistentVolumeSource = copy(nodePublishSecretRef = Some(value))
}

