package io.k8s.api.core.v1


/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFileVolumeSource(
  readOnly : Option[Boolean] = None,
  secretName : String,
  shareName : String
) {
  def withReadOnly(value: Boolean) : AzureFileVolumeSource = copy(readOnly = Some(value))
  def withSecretName(value: String) : AzureFileVolumeSource = copy(secretName = value)
  def withShareName(value: String) : AzureFileVolumeSource = copy(shareName = value)
}

