package io.k8s.api.core.v1


/** AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. */
final case class AzureDiskVolumeSource(
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  diskURI : String,
  diskName : String,
  cachingMode : Option[String] = None
) {
  def withReadOnly(value: Boolean) : AzureDiskVolumeSource = copy(readOnly = Some(value))
  def withFsType(value: String) : AzureDiskVolumeSource = copy(fsType = Some(value))
  def withDiskURI(value: String) : AzureDiskVolumeSource = copy(diskURI = value)
  def withDiskName(value: String) : AzureDiskVolumeSource = copy(diskName = value)
  def withCachingMode(value: String) : AzureDiskVolumeSource = copy(cachingMode = Some(value))
}

