package io.k8s.api.core.v1


/** Affinity is a group of affinity scheduling rules. */
final case class Affinity(
  nodeAffinity : Option[io.k8s.api.core.v1.NodeAffinity] = None,
  podAffinity : Option[io.k8s.api.core.v1.PodAffinity] = None,
  podAntiAffinity : Option[io.k8s.api.core.v1.PodAntiAffinity] = None
) {
  def withNodeAffinity(value: io.k8s.api.core.v1.NodeAffinity) : Affinity = copy(nodeAffinity = Some(value))
  def withPodAffinity(value: io.k8s.api.core.v1.PodAffinity) : Affinity = copy(podAffinity = Some(value))
  def withPodAntiAffinity(value: io.k8s.api.core.v1.PodAntiAffinity) : Affinity = copy(podAntiAffinity = Some(value))
}

