package io.k8s.api.coordination.v1


/** LeaseSpec is a specification of a Lease. */
final case class LeaseSpec(
  leaseTransitions : Option[Int] = None,
  holderIdentity : Option[String] = None,
  leaseDurationSeconds : Option[Int] = None,
  renewTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  acquireTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
) {
  def withLeaseTransitions(value: Int) : LeaseSpec = copy(leaseTransitions = Some(value))
  def withHolderIdentity(value: String) : LeaseSpec = copy(holderIdentity = Some(value))
  def withLeaseDurationSeconds(value: Int) : LeaseSpec = copy(leaseDurationSeconds = Some(value))
  def withRenewTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(renewTime = Some(value))
  def withAcquireTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(acquireTime = Some(value))
}

