package io.k8s.api.coordination.v1

import dev.hnaderi.k8s._

/** Lease defines a lease concept. */
final case class Lease(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.coordination.v1.LeaseSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "Lease", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Lease = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.coordination.v1.LeaseSpec) : Lease = copy(spec = Some(value))
}

