package io.k8s.api.certificates.v1


/** CertificateSigningRequestStatus contains conditions used to indicate approved/denied/failed status of the request, and the issued certificate. */
final case class CertificateSigningRequestStatus(
  certificate : Option[String] = None,
  conditions : Option[Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]] = None
) {
  def withCertificate(value: String) : CertificateSigningRequestStatus = copy(certificate = Some(value))
  def withConditions(value: Seq[io.k8s.api.certificates.v1.CertificateSigningRequestCondition]) : CertificateSigningRequestStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.certificates.v1.CertificateSigningRequestCondition*) : CertificateSigningRequestStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

}

