package io.k8s.api.certificates.v1

import dev.hnaderi.k8s._

/** CertificateSigningRequestList is a collection of CertificateSigningRequest objects */
final case class CertificateSigningRequestList(
  items : Seq[io.k8s.api.certificates.v1.CertificateSigningRequest],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "CertificateSigningRequestList", "v1")

  def withItems(value: Seq[io.k8s.api.certificates.v1.CertificateSigningRequest]) : CertificateSigningRequestList = copy(items = value)
  def addItems(newValues: io.k8s.api.certificates.v1.CertificateSigningRequest*) : CertificateSigningRequestList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CertificateSigningRequestList = copy(metadata = Some(value))
}

