package io.k8s.api.certificates.v1

import dev.hnaderi.k8s._

/** CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

Kubelets use this API to obtain:
 1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
 2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers. */
final case class CertificateSigningRequest(
  status : Option[io.k8s.api.certificates.v1.CertificateSigningRequestStatus] = None,
  spec : io.k8s.api.certificates.v1.CertificateSigningRequestSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("certificates.k8s.io", "CertificateSigningRequest", "v1")

  def withStatus(value: io.k8s.api.certificates.v1.CertificateSigningRequestStatus) : CertificateSigningRequest = copy(status = Some(value))
  def withSpec(value: io.k8s.api.certificates.v1.CertificateSigningRequestSpec) : CertificateSigningRequest = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CertificateSigningRequest = copy(metadata = Some(value))
}

