package io.k8s.api.batch.v1


/** UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters. */
final case class UncountedTerminatedPods(
  failed : Option[Seq[String]] = None,
  succeeded : Option[Seq[String]] = None
) {
  def withFailed(value: Seq[String]) : UncountedTerminatedPods = copy(failed = Some(value))
  def addFailed(newValues: String*) : UncountedTerminatedPods = copy(failed = Some(failed.fold(newValues)(_ ++ newValues)))

  def withSucceeded(value: Seq[String]) : UncountedTerminatedPods = copy(succeeded = Some(value))
  def addSucceeded(newValues: String*) : UncountedTerminatedPods = copy(succeeded = Some(succeeded.fold(newValues)(_ ++ newValues)))

}

