package io.k8s.api.batch.v1


/** PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check. */
final case class PodFailurePolicyOnExitCodesRequirement(
  containerName : Option[String] = None,
  operator : String,
  values : Seq[Int]
) {
  def withContainerName(value: String) : PodFailurePolicyOnExitCodesRequirement = copy(containerName = Some(value))
  def withOperator(value: String) : PodFailurePolicyOnExitCodesRequirement = copy(operator = value)
  def withValues(value: Seq[Int]) : PodFailurePolicyOnExitCodesRequirement = copy(values = value)
  def addValues(newValues: Int*) : PodFailurePolicyOnExitCodesRequirement = copy(values = values ++ newValues)

}

