package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** JobList is a collection of jobs. */
final case class JobList(
  items : Seq[io.k8s.api.batch.v1.Job],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "JobList", "v1")

  def withItems(value: Seq[io.k8s.api.batch.v1.Job]) : JobList = copy(items = value)
  def addItems(newValues: io.k8s.api.batch.v1.Job*) : JobList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : JobList = copy(metadata = Some(value))
}

