package io.k8s.api.batch.v1


/** JobCondition describes current state of a job. */
final case class JobCondition(
  lastProbeTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withLastProbeTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobCondition = copy(lastProbeTime = Some(value))
  def withReason(value: String) : JobCondition = copy(reason = Some(value))
  def withStatus(value: String) : JobCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : JobCondition = copy(message = Some(value))
  def withType(value: String) : JobCondition = copy(`type` = value)
}

