package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** Job represents the configuration of a single job. */
final case class Job(
  status : Option[io.k8s.api.batch.v1.JobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "Job", "v1")

  def withStatus(value: io.k8s.api.batch.v1.JobStatus) : Job = copy(status = Some(value))
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : Job = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Job = copy(metadata = Some(value))
}

