package io.k8s.api.batch.v1

import dev.hnaderi.k8s._

/** CronJobList is a collection of cron jobs. */
final case class CronJobList(
  items : Seq[io.k8s.api.batch.v1.CronJob],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "CronJobList", "v1")

  def withItems(value: Seq[io.k8s.api.batch.v1.CronJob]) : CronJobList = copy(items = value)
  def addItems(newValues: io.k8s.api.batch.v1.CronJob*) : CronJobList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CronJobList = copy(metadata = Some(value))
}

