package io.k8s.api.autoscaling.v2beta2


/** MetricValueStatus holds the current value for a metric */
final case class MetricValueStatus(
  averageUtilization : Option[Int] = None,
  averageValue : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  value : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {
  def withAverageUtilization(value: Int) : MetricValueStatus = copy(averageUtilization = Some(value))
  def withAverageValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(averageValue = Some(value))
  def withValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(value = Some(value))
}

