package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s._

/** HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects. */
final case class HorizontalPodAutoscalerList(
  items : Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscalerList", "v2beta2")

  def withItems(value: Seq[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler]) : HorizontalPodAutoscalerList = copy(items = value)
  def addItems(newValues: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler*) : HorizontalPodAutoscalerList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : HorizontalPodAutoscalerList = copy(metadata = Some(value))
}

