package io.k8s.api.autoscaling.v2beta2


/** ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). */
final case class ExternalMetricSource(
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2beta2.MetricTarget
) {
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ExternalMetricSource = copy(metric = value)
  def withTarget(value: io.k8s.api.autoscaling.v2beta2.MetricTarget) : ExternalMetricSource = copy(target = value)
}

