package io.k8s.api.autoscaling.v2


/** PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second). */
final case class PodsMetricStatus(
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier
) {
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : PodsMetricStatus = copy(current = value)
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : PodsMetricStatus = copy(metric = value)
}

