package io.k8s.api.autoscaling.v2


/** PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value. */
final case class PodsMetricSource(
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : PodsMetricSource = copy(metric = value)
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : PodsMetricSource = copy(target = value)
}

