package io.k8s.api.autoscaling.v2


/** HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler. */
final case class HorizontalPodAutoscalerSpec(
  maxReplicas : Int,
  scaleTargetRef : io.k8s.api.autoscaling.v2.CrossVersionObjectReference,
  minReplicas : Option[Int] = None,
  metrics : Option[Seq[io.k8s.api.autoscaling.v2.MetricSpec]] = None,
  behavior : Option[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] = None
) {
  def withMaxReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = value)
  def withScaleTargetRef(value: io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = value)
  def withMinReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = Some(value))
  def withMetrics(value: Seq[io.k8s.api.autoscaling.v2.MetricSpec]) : HorizontalPodAutoscalerSpec = copy(metrics = Some(value))
  def addMetrics(newValues: io.k8s.api.autoscaling.v2.MetricSpec*) : HorizontalPodAutoscalerSpec = copy(metrics = Some(metrics.fold(newValues)(_ ++ newValues)))

  def withBehavior(value: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior) : HorizontalPodAutoscalerSpec = copy(behavior = Some(value))
}

