package io.k8s.api.autoscaling.v2


/** HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). */
final case class HorizontalPodAutoscalerBehavior(
  scaleDown : Option[io.k8s.api.autoscaling.v2.HPAScalingRules] = None,
  scaleUp : Option[io.k8s.api.autoscaling.v2.HPAScalingRules] = None
) {
  def withScaleDown(value: io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleDown = Some(value))
  def withScaleUp(value: io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleUp = Some(value))
}

