package io.k8s.api.autoscaling.v2


/** HPAScalingPolicy is a single policy which must hold true for a specified past interval. */
final case class HPAScalingPolicy(
  periodSeconds : Int,
  `type` : String,
  value : Int
) {
  def withPeriodSeconds(value: Int) : HPAScalingPolicy = copy(periodSeconds = value)
  def withType(value: String) : HPAScalingPolicy = copy(`type` = value)
  def withValue(value: Int) : HPAScalingPolicy = copy(value = value)
}

