package io.k8s.api.autoscaling.v2


/** ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object. */
final case class ExternalMetricStatus(
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier
) {
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : ExternalMetricStatus = copy(current = value)
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : ExternalMetricStatus = copy(metric = value)
}

