package io.k8s.api.autoscaling.v2


/** ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. */
final case class ContainerResourceMetricStatus(
  container : String,
  current : io.k8s.api.autoscaling.v2.MetricValueStatus,
  name : String
) {
  def withContainer(value: String) : ContainerResourceMetricStatus = copy(container = value)
  def withCurrent(value: io.k8s.api.autoscaling.v2.MetricValueStatus) : ContainerResourceMetricStatus = copy(current = value)
  def withName(value: String) : ContainerResourceMetricStatus = copy(name = value)
}

