package io.k8s.api.autoscaling.v2


/** ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set. */
final case class ContainerResourceMetricSource(
  container : String,
  name : String,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {
  def withContainer(value: String) : ContainerResourceMetricSource = copy(container = value)
  def withName(value: String) : ContainerResourceMetricSource = copy(name = value)
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : ContainerResourceMetricSource = copy(target = value)
}

