package io.k8s.api.autoscaling.v1


/** ScaleStatus represents the current status of a scale subresource. */
final case class ScaleStatus(
  replicas : Int,
  selector : Option[String] = None
) {
  def withReplicas(value: Int) : ScaleStatus = copy(replicas = value)
  def withSelector(value: String) : ScaleStatus = copy(selector = Some(value))
}

