package io.k8s.api.autoscaling.v1


/** current status of a horizontal pod autoscaler */
final case class HorizontalPodAutoscalerStatus(
  desiredReplicas : Int,
  lastScaleTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  observedGeneration : Option[Int] = None,
  currentReplicas : Int,
  currentCPUUtilizationPercentage : Option[Int] = None
) {
  def withDesiredReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(desiredReplicas = value)
  def withLastScaleTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : HorizontalPodAutoscalerStatus = copy(lastScaleTime = Some(value))
  def withObservedGeneration(value: Int) : HorizontalPodAutoscalerStatus = copy(observedGeneration = Some(value))
  def withCurrentReplicas(value: Int) : HorizontalPodAutoscalerStatus = copy(currentReplicas = value)
  def withCurrentCPUUtilizationPercentage(value: Int) : HorizontalPodAutoscalerStatus = copy(currentCPUUtilizationPercentage = Some(value))
}

