package io.k8s.api.autoscaling.v1


/** specification of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscalerSpec(
  maxReplicas : Int,
  minReplicas : Option[Int] = None,
  scaleTargetRef : io.k8s.api.autoscaling.v1.CrossVersionObjectReference,
  targetCPUUtilizationPercentage : Option[Int] = None
) {
  def withMaxReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = value)
  def withMinReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = Some(value))
  def withScaleTargetRef(value: io.k8s.api.autoscaling.v1.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = value)
  def withTargetCPUUtilizationPercentage(value: Int) : HorizontalPodAutoscalerSpec = copy(targetCPUUtilizationPercentage = Some(value))
}

