package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s._

/** configuration of a horizontal pod autoscaler. */
final case class HorizontalPodAutoscaler(
  status : Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscaler", "v1")

  def withStatus(value: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = Some(value))
  def withSpec(value: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = Some(value))
}

