package io.k8s.api.authorization.v1


/** SubjectAccessReviewStatus */
final case class SubjectAccessReviewStatus(
  allowed : Boolean,
  denied : Option[Boolean] = None,
  evaluationError : Option[String] = None,
  reason : Option[String] = None
) {
  def withAllowed(value: Boolean) : SubjectAccessReviewStatus = copy(allowed = value)
  def withDenied(value: Boolean) : SubjectAccessReviewStatus = copy(denied = Some(value))
  def withEvaluationError(value: String) : SubjectAccessReviewStatus = copy(evaluationError = Some(value))
  def withReason(value: String) : SubjectAccessReviewStatus = copy(reason = Some(value))
}

