package io.k8s.api.authorization.v1


/** SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set */
final case class SubjectAccessReviewSpec(
  groups : Option[Seq[String]] = None,
  resourceAttributes : Option[io.k8s.api.authorization.v1.ResourceAttributes] = None,
  uid : Option[String] = None,
  extra : Option[Map[String, Seq[String]]] = None,
  user : Option[String] = None,
  nonResourceAttributes : Option[io.k8s.api.authorization.v1.NonResourceAttributes] = None
) {
  def withGroups(value: Seq[String]) : SubjectAccessReviewSpec = copy(groups = Some(value))
  def addGroups(newValues: String*) : SubjectAccessReviewSpec = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))

  def withResourceAttributes(value: io.k8s.api.authorization.v1.ResourceAttributes) : SubjectAccessReviewSpec = copy(resourceAttributes = Some(value))
  def withUid(value: String) : SubjectAccessReviewSpec = copy(uid = Some(value))
  def withExtra(value: Map[String, Seq[String]]) : SubjectAccessReviewSpec = copy(extra = Some(value))
  def addExtra(newValues: (String, Seq[String])*) : SubjectAccessReviewSpec = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))

  def withUser(value: String) : SubjectAccessReviewSpec = copy(user = Some(value))
  def withNonResourceAttributes(value: io.k8s.api.authorization.v1.NonResourceAttributes) : SubjectAccessReviewSpec = copy(nonResourceAttributes = Some(value))
}

