package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** SubjectAccessReview checks whether or not a user or group can perform an action. */
final case class SubjectAccessReview(
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  spec : io.k8s.api.authorization.v1.SubjectAccessReviewSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SubjectAccessReview", "v1")

  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SubjectAccessReview = copy(status = Some(value))
  def withSpec(value: io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : SubjectAccessReview = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SubjectAccessReview = copy(metadata = Some(value))
}

