package io.k8s.api.authorization.v1


/** SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set */
final case class SelfSubjectAccessReviewSpec(
  nonResourceAttributes : Option[io.k8s.api.authorization.v1.NonResourceAttributes] = None,
  resourceAttributes : Option[io.k8s.api.authorization.v1.ResourceAttributes] = None
) {
  def withNonResourceAttributes(value: io.k8s.api.authorization.v1.NonResourceAttributes) : SelfSubjectAccessReviewSpec = copy(nonResourceAttributes = Some(value))
  def withResourceAttributes(value: io.k8s.api.authorization.v1.ResourceAttributes) : SelfSubjectAccessReviewSpec = copy(resourceAttributes = Some(value))
}

