package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action */
final case class SelfSubjectAccessReview(
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  spec : io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SelfSubjectAccessReview", "v1")

  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SelfSubjectAccessReview = copy(status = Some(value))
  def withSpec(value: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : SelfSubjectAccessReview = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectAccessReview = copy(metadata = Some(value))
}

