package io.k8s.api.authorization.v1


/** ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface */
final case class ResourceAttributes(
  name : Option[String] = None,
  version : Option[String] = None,
  resource : Option[String] = None,
  verb : Option[String] = None,
  group : Option[String] = None,
  subresource : Option[String] = None,
  namespace : Option[String] = None
) {
  def withName(value: String) : ResourceAttributes = copy(name = Some(value))
  def withVersion(value: String) : ResourceAttributes = copy(version = Some(value))
  def withResource(value: String) : ResourceAttributes = copy(resource = Some(value))
  def withVerb(value: String) : ResourceAttributes = copy(verb = Some(value))
  def withGroup(value: String) : ResourceAttributes = copy(group = Some(value))
  def withSubresource(value: String) : ResourceAttributes = copy(subresource = Some(value))
  def withNamespace(value: String) : ResourceAttributes = copy(namespace = Some(value))
}

